<?php
declare(strict_types=1);

namespace FCA\StockApi\Document\Offer\Dealer;

use FCA\StockApi\Document\Base;

class Coordinates extends Base
{
    /**
     * @var float
     */
    protected $longitude;

    /**
     * @var float
     */
    protected $latitude;

    public function __construct(float $longitude, float $latitude)
    {
        $this->longitude = $longitude;
        $this->latitude = $latitude;
    }

    public function getLongitude(): float
    {
        return $this->longitude;
    }

    public function getLatitude(): float
    {
        return $this->latitude;
    }

    /**
     * @return float[]
     */
    public function toArray(): array
    {
        return [
            'longitude' => $this->getLongitude(),
            'latitude' => $this->getLatitude()
        ];
    }
}
