<?php
declare(strict_types=1);

namespace FCA\StockApi\Document\Offer;

use FCA\StockApi\Document\Base;

class Price extends Base
{
    /**
     * @var Price\Details
     */
    protected $base;

    /**
     * @var Price\Details
     */
    protected $final;

    /**
     * @var float
     */
    protected $building;

    public function __construct(float $base_netto, float $base_brutto, float $final_netto, float $final_brutto, float $building)
    {
        $this->base = new Price\Details($base_netto, $base_brutto);
        $this->final = new Price\Details($final_netto, $final_brutto);
        $this->building = $building;
    }

    public function getBase(): Price\Details
    {
        return $this->base;
    }

    public function getFinal(): Price\Details
    {
        return $this->final;
    }

    public function getBuilding(): float
    {
        return $this->building;
    }

    /**
     * @return Price\Details[]
     */
    public function toArray(): array
    {
        return [
            'base' => $this->getBase()->toArray(),
            'final' => $this->getFinal()->toArray(),
            'building' => $this->getBuilding(),
        ];
    }
}
