<?php
declare(strict_types=1);

namespace FCA\StockApi\Document;

use FCA\StockApi\Exception\ApiException;

abstract class Base
{
    protected function checkKeys(array $requiredKeys, array $inputData): void
    {
        foreach ($requiredKeys as $key) {
            if (!array_key_exists($key, $inputData)) {
                throw new ApiException('Key: "' . $key . '" is undefined!"');
            }
        }
    }

    abstract public function toArray(): array;
}
