<?php
declare(strict_types=1);

namespace FCA\StockApi\Document\Offer;

use FCA\StockApi\Document\Base;

class Color extends Base
{
    /**
     * @var string
     */
    protected $code;

    /**
     * @var string
     */
    protected $name;

    /**
     * @var string|null
     */
    protected $category;

    /**
     * @var string|null
     */
    protected $type;

    public function __construct(string $code, string $name, ?string $category, ?string $type)
    {
        $this->code = $code;
        $this->name = $name;
        $this->category = $category;
        $this->type = $type;
    }

    public function getCode(): string
    {
        return $this->code;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function getCategory(): ?string
    {
        return $this->category;
    }

    public function getType(): ?string
    {
        return $this->type;
    }

    /**
     * @return string[]
     */
    public function toArray(): array
    {
        return [
            'code' => $this->getCode(),
            'name' => $this->getName(),
            'category' => $this->getCategory(),
            'type' => $this->getType()
        ];
    }
}
