<?php
declare(strict_types=1);

namespace FCA\StockApi\Document\Offer\Price;

use FCA\StockApi\Document\Base;

class Installment extends Base
{
    /**
     * @var string
     */
    protected $titleDescription;

    /**
     * @var string
     */
    protected $priceType;

    /**
     * @var int
     */
    protected $installment;

    /**
     * @var string
     */
    protected $note;


    public function __construct(array $leasing)
    {
        $this->titleDescription = $leasing['titleDescription'];
        $this->priceType = $leasing['priceType'];
        $this->installment = $leasing['installment'];
        $this->note = $leasing['note'];
    }

    /**
     * @return string
     */
    public function getTitleDescription(): string
    {
        return $this->titleDescription;
    }

    /**
     * @return string
     */
    public function getPriceType(): string
    {
        return $this->priceType;
    }

    /**
     * @return int
     */
    public function getInstallment(): int
    {
        return $this->installment;
    }

    /**
     * @return string
     */
    public function getNote(): string
    {
        return $this->note;
    }

    /**
     * @return float[]
     */
    public function toArray(): array
    {
        return [
            'titleDescription' => $this->getTitleDescription(),
            'priceType' => $this->getPriceType(),
            'installment' => $this->getInstallment(),
            'note' => $this->getNote()
        ];
    }
}
