<?php
declare(strict_types=1);

namespace FCA\StockApi\Document\Offer\Price;

use FCA\StockApi\Document\Base;

class Installment extends Base
{
    /**
     * @var string|null
     */
    protected $titleDescription;

    /**
     * @var string|null
     */
    protected $priceType;

    /**
     * @var int|null
     */
    protected $installment;

    /**
     * @var string|null
     */
    protected $note;


    public function __construct(array $leasing)
    {
        $this->titleDescription = $leasing['titleDescription'];
        $this->priceType = $leasing['priceType'];
        $this->installment = $leasing['installment'];
        $this->note = $leasing['note'];
    }

    /**
     * @return string|null
     */
    public function getTitleDescription(): ?string
    {
        return $this->titleDescription;
    }

    /**
     * @return string|null
     */
    public function getPriceType(): ?string
    {
        return $this->priceType;
    }

    /**
     * @return int|null
     */
    public function getInstallment(): ?int
    {
        return $this->installment;
    }

    /**
     * @return string|null
     */
    public function getNote(): ?string
    {
        return $this->note;
    }

    /**
     * @return float[]
     */
    public function toArray(): array
    {
        return [
            'titleDescription' => $this->getTitleDescription(),
            'priceType' => $this->getPriceType(),
            'installment' => $this->getInstallment(),
            'note' => $this->getNote()
        ];
    }
}
