<?php
declare(strict_types=1);

namespace FCA\StockApi\Collection\Filter\Builder;

class ValueTypes
{
    const STRING = ['string', 'NULL'];
    const INTEGER = ['integer', 'NULL'];
    const DOUBLE = ['double', 'float', 'integer', 'NULL'];
    const BOOLEAN = ['boolean', 'NULL'];
    const GEOMETRY = ['geometry'];

    private static $map = null;

    /**
     * @return array|bool
     */
    public static function getValueMap(): array
    {
        if (self::$map !== null) {
            return self::$map;
        } else {
            $constants = Fields::getAllFields();

            $map = [];

            $intFields = [
                Fields::ID,
                Fields::PRODUCTION_YEAR,
                Fields::ENGINE_POWER,
                Fields::GEARS,
                Fields::MILEAGE,
                Fields::PRICE_LEASING_INSTALLMENT,
            ];

            $doubleFields = [
                Fields::VERSION_PRICE,
                Fields::BASE_PRICE_NETTO,
                Fields::BASE_PRICE_BRUTTO,
                Fields::FINAL_PRICE_NETTO,
                Fields::FINAL_PRICE_BRUTTO,
                Fields::BUILDING_PRICE,
                Fields::EQUIPMENT_PRICE,
                Fields::ENGINE_CAPACITY,
            ];

            $booleanFields = [
                Fields::IS_DEMO,
                Fields::IS_KM0,
            ];

            $geometryFields = [
                Fields::DEALER_COORDINATES,
            ];

            foreach ($constants as $constant) {
                if (in_array($constant, $intFields)) {
                    $map[$constant] = self::INTEGER;
                } elseif (in_array($constant, $doubleFields)) {
                    $map[$constant] = self::DOUBLE;
                } elseif (in_array($constant, $booleanFields)) {
                    $map[$constant] = self::BOOLEAN;
                } elseif (in_array($constant, $geometryFields)) {
                    $map[$constant] = self::GEOMETRY;
                } else {
                    $map[$constant] = self::STRING;
                }
            }

            self::$map = null;

            return $map;
        }
    }
}
