<?php
declare(strict_types=1);

namespace FCA\StockApi\Document\Offer;

use FCA\StockApi\Document\Base;

class Equipment extends Base
{
    /**
     * @var string
     */
    protected $code;

    /**
     * @var string
     */
    protected $type;

    /**
     * @var string
     */
    protected $name;

    /**
     * @var null|float
     */
    protected $price;

    /**
     * @var null|float
     */
    protected $gross_price;

    /**
     * @var array|null
     */
    protected $contents;

    public function __construct(
        string $code,
        string $type,
        string $name,
        ?float $price = null,
        ?float $gross_price = null,
        ?array $contents = null
    ) {
        $this->code = $code;
        $this->type = $type;
        $this->name = $name;
        $this->price = $price;
        $this->gross_price = $gross_price;
        $this->contents = $contents;
    }

    public function getCode(): string
    {
        return $this->code;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function getPrice(): ?float
    {
        return $this->price;
    }


    public function getGrossPrice(): ?float
    {
        return $this->gross_price;
    }

    public function getContents(): ?array
    {
        return $this->contents;
    }

    public function toArray(): array
    {
        return [
            'code' => $this->getCode(),
            'name' => $this->getName(),
            'type' => $this->getType(),
            'price' => $this->getPrice(),
            'gross_price' => $this->getGrossPrice(),
            'contents' => $this->getContents()
        ];
    }
}
