<?php
declare(strict_types=1);

namespace FCA\StockApi\Document\Offer;

use FCA\StockApi\Document\Base;

class Price extends Base
{
    /**
     * @var Price\Details
     */
    protected $base;

    /**
     * @var Price\Details
     */
    protected $final;

    public function __construct(float $base_netto, float $base_brutto, float $final_netto, float $final_brutto)
    {
        $this->base = new Price\Details($base_netto, $base_brutto);
        $this->final = new Price\Details($final_netto, $final_brutto);
    }

    public function getBase(): Price\Details
    {
        return $this->base;
    }

    public function getFinal(): Price\Details
    {
        return $this->final;
    }

    /**
     * @return Price\Details[]
     */
    public function toArray(): array
    {
        return [
            'base' => $this->getBase()->toArray(),
            'final' => $this->getFinal()->toArray(),
        ];
    }
}
