<?php
declare(strict_types=1);

namespace FCA\StockApi\Collection\Filter\Builder;

class Fields
{
    public const UID = 'uid';
    public const ID = 'vehicle_id'; // int

    public const BRAND_CODE = 'brand.code';
    public const BRAND_NAME = 'brand.name';
    public const BRAND_SLUG = 'brand.slug';

    public const MODEL_CODE = 'model.code';
    public const MODEL_COMMERCIAL_CODE = 'model.commercial_code';
    public const MODEL_NAME = 'model.name';
    public const MODEL_GROUP_SLUG = 'model.group.slug';
    public const MODEL_GROUP_NAME = 'model.group.name';

    public const VERSION_CODE = 'version.code';
    public const VERSION_COMMERCIAL_CODE = 'version.commercial_code';
    public const VERSION_NAME = 'version.name';
    public const VERSION_SLUG = 'version.slug';
    public const VERSION_PRICE = 'version.price'; // double

    public const SERIES_CODE = 'series.code';
    public const SERIES_SPECIAL_CODE = 'series.special_code';

    public const DEALER = 'dealer';
    public const DEALER_CODE = 'dealer.code';
    public const DEALER_SITECODE = 'dealer.sitecode';
    public const DEALER_NAME = 'dealer.name';
    public const DEALER_EMAIL = 'dealer.email';
    public const DEALER_STREET = 'dealer.street';
    public const DEALER_POST_CODE = 'dealer.post_code';
    public const DEALER_CITY = 'dealer.city';
    public const DEALER_REGION = 'dealer.region';
    public const DEALER_COORDINATES = 'dealer.coordinates'; // geometry
    public const DEALER_WEBSITE = 'dealer.website';
    public const DEALER_PHONES = 'dealer.phones';

    public const STATUS = 'status';

    public const BASE_PRICE_NETTO = 'price.base.netto'; // double
    public const BASE_PRICE_BRUTTO = 'price.base.brutto'; // double
    public const FINAL_PRICE_NETTO = 'price.final.netto'; // double
    public const FINAL_PRICE_BRUTTO = 'price.final.brutto'; // double
    public const BUILDING_PRICE = 'price.building'; // double
    public const DISCOUNT_PERCENT = 'price.discount.percent';
    public const DISCOUNT_AMOUNT_NETTO = 'price.discount.amount.netto';
    public const DISCOUNT_AMOUNT_BRUTTO = 'price.discount.amount.brutto';

    public const IS_DEMO = 'is_demo';
    public const IS_KM0 = 'is_km0';
    public const MILEAGE = 'mileage'; // int

    public const PRODUCTION_YEAR = 'year_of_production'; // int
    public const PRODUCTION_DATE = 'date_of_production';
    public const REGISTRATION_DATE = 'registration_date';

    public const SINCOM = 'sincom';
    public const RRDI = 'rrdi';

    public const COLOR_CODE = 'color.code';
    public const COLOR_CATEGORY = 'color.category';
    public const COLOR_TYPE = 'color.type';

    public const INTERIOR_CODE = 'interior.code';
    public const INTERIOR_NAME = 'interior.name';
    public const INTERIOR_TYPE = 'interior.type';

    public const DESCRIPTION = 'description';

    public const SERIAL_NO = 'serial_no';

    public const GROUPS = 'groups';
    public const LABELS = 'labels';
    public const VISIT_COUNT = 'visit_count';
    public const FINANCIAL_PRODUCTS = 'financial_products';

    public const EQUIPMENT_CODE = 'equipment.code';
    public const EQUIPMENT_TYPE = 'equipment.type';
    public const EQUIPMENT_NAME = 'equipment.name';
    public const EQUIPMENT_PRICE = 'equipment.price'; // double | null
    public const EQUIPMENT_OPTIONS = 'equipment_options';

    public const VEHICLE_TYPE = 'technical_data.vehicle_type';
    public const FUEL_TYPE = 'technical_data.fuel_type';
    public const DOOR = 'technical_data.door';
    public const SEATS = 'technical_data.seats';
    public const ENGINE_CAPACITY = 'technical_data.engine_capacity'; // double
    public const ENGINE_POWER = 'technical_data.engine_power'; // int
    public const AVERAGE_FUEL_CONSUMPTION = 'technical_data.average_fuel_consumption';
    public const BODY_TYPE = 'technical_data.body_type';
    public const DRIVE_TYPE = 'technical_data.drive_type';
    public const GEARBOX_TYPE = 'technical_data.gearbox_type';
    public const GEARS = 'technical_data.gears'; // int
    public const EQUIPMENT_LEVEL = 'technical_data.equipment_level';
    public const EMISSION_STANDARD = 'technical_data.emission_standard';
    public const CO2_EMISSION = 'technical_data.co2_emission';
    public const INSTALLMENT_B2B_L101 = 'installment-b2b-l101'; // int
    public const INSTALLMENT_B2C_P0P = 'installment-b2c-p0p'; // int

    public static $EXTRA_FIELDS = [];

    public static function getAllFields(): array
    {
        return array_merge([
            self::UID,
            self::ID,
            self::BRAND_CODE,
            self::BRAND_NAME,
            self::BRAND_SLUG,
            self::MODEL_CODE,
            self::MODEL_COMMERCIAL_CODE,
            self::MODEL_NAME,
            self::MODEL_GROUP_SLUG,
            self::MODEL_GROUP_NAME,
            self::VERSION_CODE,
            self::VERSION_COMMERCIAL_CODE,
            self::VERSION_NAME,
            self::VERSION_PRICE,
            self::VERSION_SLUG,
            self::SERIES_CODE,
            self::SERIES_SPECIAL_CODE,
            self::DEALER,
            self::DEALER_CODE,
            self::DEALER_SITECODE,
            self::DEALER_NAME,
            self::DEALER_EMAIL,
            self::DEALER_STREET,
            self::DEALER_POST_CODE,
            self::DEALER_CITY,
            self::DEALER_REGION,
            self::DEALER_COORDINATES,
            self::DEALER_WEBSITE,
            self::DEALER_PHONES,
            self::STATUS,
            self::BASE_PRICE_NETTO,
            self::BASE_PRICE_BRUTTO,
            self::FINAL_PRICE_NETTO,
            self::FINAL_PRICE_BRUTTO,
            self::BUILDING_PRICE,
            self::DISCOUNT_PERCENT,
            self::DISCOUNT_AMOUNT_NETTO,
            self::DISCOUNT_AMOUNT_BRUTTO,
            self::INSTALLMENT_B2B_L101,
            self::INSTALLMENT_B2C_P0P,
            self::IS_DEMO,
            self::IS_KM0,
            self::MILEAGE,
            self::PRODUCTION_YEAR,
            self::PRODUCTION_DATE,
            self::REGISTRATION_DATE,
            self::SINCOM,
            self::RRDI,
            self::COLOR_CODE,
            self::COLOR_CATEGORY,
            self::COLOR_TYPE,
            self::INTERIOR_CODE,
            self::INTERIOR_TYPE,
            self::INTERIOR_NAME,
            self::DESCRIPTION,
            self::SERIAL_NO,
            self::GROUPS,
            self::LABELS,
            self::EQUIPMENT_CODE,
            self::EQUIPMENT_TYPE,
            self::EQUIPMENT_NAME,
            self::EQUIPMENT_PRICE,
            self::EQUIPMENT_OPTIONS,
            self::VEHICLE_TYPE,
            self::FUEL_TYPE,
            self::DOOR,
            self::SEATS,
            self::ENGINE_CAPACITY,
            self::ENGINE_POWER,
            self::AVERAGE_FUEL_CONSUMPTION,
            self::BODY_TYPE,
            self::DRIVE_TYPE,
            self::GEARBOX_TYPE,
            self::GEARS,
            self::EQUIPMENT_LEVEL,
            self::EMISSION_STANDARD,
            self::CO2_EMISSION,
            self::VISIT_COUNT,
            self::FINANCIAL_PRODUCTS
        ], self::$EXTRA_FIELDS);
    }
}
