<?php
declare(strict_types=1);

namespace FCA\StockApi\Document\Offer\Price;

use FCA\StockApi\Document\Base;

class Details extends Base
{
    /**
     * @var float
     */
    protected $netto;

    /**
     * @var float
     */
    protected $brutto;

    public function __construct(float $netto, float $brutto)
    {
        $this->netto = $netto;
        $this->brutto = $brutto;
    }

    public function getNetto(): float
    {
        return $this->netto;
    }

    public function getBrutto(): float
    {
        return $this->brutto;
    }

    /**
     * @return float[]
     */
    public function toArray(): array
    {
        return [
            'netto' => $this->getNetto(),
            'brutto' => $this->getBrutto()
        ];
    }
}
