<?php
declare(strict_types=1);

namespace FCA\StockApi\Document;

class DistinctValue extends Base
{
    /**
     * @var mixed
     */
    protected $value;

    /**
     * @var int
     */
    protected $count;

    /**
     * @param mixed $value
     */
    public function __construct($value, int $count)
    {
        $this->value = $value;
        $this->count = $count;
    }

    /**
     * @return mixed
     */
    public function getValue()
    {
        return $this->value;
    }

    public function getCount(): int
    {
        return $this->count;
    }

    public function toArray(): array
    {
        return [
            'value' => $this->getValue(),
            'count' => $this->getCount()
        ];
    }
}
