<?php
declare(strict_types=1);

namespace FCA\StockApi\Document\Offer;

use FCA\StockApi\Document\Base;

class Brand extends Base
{
    /**
     * @var string
     */
    protected $code;

    /**
     * @var string
     */
    protected $name;

    /**
     * @var string
     */
    protected $slug;

    public function __construct(string $code, string $name, string $slug)
    {
        $this->code = $code;
        $this->name = $name;
        $this->slug = $slug;
    }

    public function getCode(): string
    {
        return $this->code;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function getSlug(): string
    {
        return $this->slug;
    }

    /**
     * @return string[]
     */
    public function toArray(): array
    {
        return [
            'code' => $this->getCode(),
            'name' => $this->getName(),
            'slug' => $this->getSlug()
        ];
    }
}
