<?php
declare(strict_types=1);

namespace FCA\StockApi\Document\Offer;

use FCA\StockApi\Document\Base;

class Model extends Base
{
    /**
     * @var string
     */
    protected $code;

    /**
     * @var string
     */
    protected $commercialCode;

    /**
     * @var string
     */
    protected $name;

    /**
     * @var string[]
     */
    protected $groups = [];

    public function __construct(string $code, string $commercial_code, string $name, array $groups = [])
    {
        $this->code = $code;
        $this->commercialCode = $commercial_code;
        $this->name = $name;
        $this->groups = $groups;
    }

    public function getCode(): string
    {
        return $this->code;
    }

    public function getCommercialCode(): string
    {
        return $this->commercialCode;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function getGroup(): array
    {
        return $this->groups;
    }

    public function toArray(): array
    {
        return [
            'code' => $this->getCode(),
            'commercialCode' => $this->getCommercialCode(),
            'name' => $this->getName(),
            'group' => $this->getGroup()
        ];
    }
}
