<?php
declare(strict_types=1);

namespace FCA\StockApi\Document\Offer;

use FCA\StockApi\Document\Base;

class Series extends Base
{
    /**
     * @var string
     */
    protected $code;

    /**
     * @var string
     */
    protected $specialCode;

    public function __construct(string $code, string $special_code)
    {
        $this->code = $code;
        $this->specialCode = $special_code;
    }

    public function getCode(): string
    {
        return $this->code;
    }

    public function getSpecialCode(): string
    {
        return $this->specialCode;
    }

    /**
     * @return string[]
     */
    public function toArray(): array
    {
        return [
            'code' => $this->getCode(),
            'specialCode' => $this->getSpecialCode()
        ];
    }
}
