<?php
declare(strict_types=1);

namespace FCA\StockApi\Document\Offer;

use FCA\StockApi\Document\Base;

class TechnicalData extends Base
{
    /**
     * @var string
     */
    protected $vehicleType;

    /**
     * @var string
     */
    protected $fuelType;

    /**
     * @var string
     */
    protected $fuelShortType;

    /**
     * @var string
     */
    protected $door;

    /**
     * @var string
     */
    protected $seats;

    /**
     * @var float
     */
    protected $engineCapacity;

    /**
     * @var string
     */
    protected $engineType;

    /**
     * @var int
     */
    protected $enginePower;

    /***
     * @var string
     */
    protected $averageFuelConsumption;

    /**
     * @var string
     */
    protected $bodyType;

    /**
     * @var string
     */
    protected $driveType;

    /**
     * @var string
     */
    protected $gearboxType;

    /**
     * @var string
     */
    protected $gears;

    /**
     * @var string
     */
    protected $equipmentLevel;

    /**
     * @var string
     */
    protected $emissionStandard;

    /**
     * @var string
     */
    protected $co2Emission;

    public function __construct(array $technical_data)
    {
        $requiredKeys = [
            'vehicle_type',
            'fuel_type',
            'fuel_short_type',
            'door',
            'seats',
            'engine_capacity',
            'engine_type',
            'engine_power',
            'average_fuel_consumption',
            'body_type',
            'drive_type',
            'gearbox_type',
            'gears',
            'equipment_level',
            'emission_standard',
            'co2_emission',
        ];

        $this->checkKeys($requiredKeys, $technical_data);

        $this->vehicleType = (string) $technical_data['vehicle_type'];
        $this->fuelType = (string) $technical_data['fuel_type'];
        $this->fuelShortType = (string) $technical_data['fuel_short_type'];
        $this->door = (string) $technical_data['door'];
        $this->seats = (string) $technical_data['seats'];
        $this->engineCapacity = (float) $technical_data['engine_capacity'];
        $this->engineType = (string) $technical_data['engine_type'];
        $this->enginePower = (int) $technical_data['engine_power'];
        $this->averageFuelConsumption = (string) $technical_data['average_fuel_consumption'];
        $this->bodyType = (string) $technical_data['body_type'];
        $this->driveType = (string) $technical_data['drive_type'];
        $this->gearboxType = (string) $technical_data['gearbox_type'];
        $this->gears = (string) $technical_data['gears'];
        $this->equipmentLevel = (string) $technical_data['equipment_level'];
        $this->emissionStandard = (string) $technical_data['emission_standard'];
        $this->co2Emission = (string) $technical_data['co2_emission'];
    }

    public function getVehicleType(): string
    {
        return $this->vehicleType;
    }

    public function getFuelType(): string
    {
        return $this->fuelType;
    }

    public function getFuelShortType(): string
    {
        return $this->fuelShortType;
    }

    public function getDoor(): string
    {
        return $this->door;
    }

    public function getSeats(): string
    {
        return $this->seats;
    }

    public function getEngineCapacity(): float
    {
        return $this->engineCapacity;
    }

    public function getEngineType(): string
    {
        return $this->engineType;
    }

    public function getEnginePower(): int
    {
        return $this->enginePower;
    }

    public function getAverageFuelConsumption(): string
    {
        return $this->averageFuelConsumption;
    }

    public function getBodyType(): string
    {
        return $this->bodyType;
    }

    public function getDriveType(): string
    {
        return $this->driveType;
    }

    public function getGearboxType(): string
    {
        return $this->gearboxType;
    }

    public function getGears(): string
    {
        return $this->gears;
    }

    public function getEquipmentLevel(): string
    {
        return $this->equipmentLevel;
    }

    public function getEmissionStandard(): string
    {
        return $this->emissionStandard;
    }

    public function getCo2Emission(): string
    {
        return $this->co2Emission;
    }

    public function toArray(): array
    {
        return [
            'vehicleType' => $this->getVehicleType(),
            'fuelType' => $this->getFuelType(),
            'fuelShortType' => $this->getFuelShortType(),
            'door' => $this->getDoor(),
            'seats' => $this->getSeats(),
            'engineCapacity' => $this->getEngineCapacity(),
            'engineType' => $this->getEngineType(),
            'enginePower' => $this->getEnginePower(),
            'averageFuelConsumption' => $this->getAverageFuelConsumption(),
            'bodyType' => $this->getBodyType(),
            'driveType' => $this->getDriveType(),
            'gearboxType' => $this->getGearboxType(),
            'gears' => $this->getGears(),
            'equipmentLevel' => $this->getEquipmentLevel(),
            'emissionStandard' => $this->getEmissionStandard(),
            'co2Emission' => $this->getCo2Emission()
        ];
    }
}
