<?php

namespace FCA\StockApi\Tests\Functional;

use FCA\StockApi\Api;
use FCA\StockApi\Collection\Filter\Builder;
use FCA\StockApi\Collection\Filter\Wizard;
use FCA\StockApi\Collection\Offer;
use FCA\StockApi\Collection\Sort\Sort;
use PHPUnit\Framework\TestCase;

class LibraryTest extends TestCase
{
    /**
     * @throws \FCA\StockApi\Exception\ApiException
     */
    public function testLibrary1()
    {
        $client = new \MongoDB\Client('mongodb://db-stock:27017');
        $db = $client->selectDatabase('stock-www');

        $api = new Api();
        $api->setDatabase($db);
        $api->setCollection('offers');

        $offerCollection = new Offer($api);

        $b = new Builder();

        $f = $b->andWhere(
            $b->is(Builder\Fields::FINAL_PRICE_NETTO, '>', 60000),
            $b->is(Builder\Fields::FINAL_PRICE_NETTO, '<', 80000)
        );

        $sort = new Sort();
        $sort->addSortBy(Builder\Fields::FINAL_PRICE_NETTO, Sort::DESC);

        $isValidResults = true;
        $lastPrice = null;
        $offers = $offerCollection->find($f, $sort->getSort());

        foreach ($offers as $offer) {
            $price = $offer->getPrice()->getFinal()->getNetto();
            if ($lastPrice !== null) {
                if ($price > $lastPrice or $price <= 60000 or $price >= 80000) {
                    $isValidResults = false;
                    break;
                }
            } elseif ($price <= 60000 or $price >= 80000) {
                $isValidResults = false;
                break;
            }
            $lastPrice = $price;
        }

        $this->assertTrue($isValidResults);
    }

    /**
     * @throws \FCA\StockApi\Exception\ApiException
     */
    public function testLibrary2()
    {
        $client = new \MongoDB\Client('mongodb://db-stock:27017');
        $db = $client->selectDatabase('stock-www');

        $api = new Api();
        $api->setDatabase($db);
        $api->setCollection('offers');

        $offerCollection = new Offer($api);

        $stock = new Wizard();
        $stock->setBrandCodes(['00'])->setModels(['357']);

        $sort = new Sort();
        $sort->addSortBy(Builder\Fields::BASE_PRICE_BRUTTO, Sort::ASC);

        $isValidResults = true;
        $lastPrice = null;
        $offers = $offerCollection->find($stock->getFilters(), $sort->getSort());

        foreach ($offers as $offer) {
            $price = $offer->getPrice()->getBase()->getBrutto();
            if ($lastPrice !== null) {
                if ($price < $lastPrice or $offer->getModel()->getCode() != '357' or $offer->getBrand()->getCode() !== '00') {
                    $isValidResults = false;
                    break;
                }
            } elseif ($offer->getModel()->getCode() != '357' or $offer->getBrand()->getCode() !== '00') {
                $isValidResults = false;
                break;
            }
            $lastPrice = $price;
        }

        $this->assertTrue($isValidResults);
    }
}
