<?php

namespace FCA\StockExporter;

use FCA\StockExporter\Exception\IncorrectField;

class ExportField
{
    const ID = 'ID';
    const SERIAL_NO = 'SERIAL_NO';
    const BRAND_ID = 'BRAND_ID';
    const BRAND_NAME = 'BRAND_NAME';
    const DEALER_ADD = 'DEALER_ADD';
    const DEALER_SINCOM = 'DEALER_SINCOM';
    const DEALER_NAME = 'DEALER_NAME';
    const VERSION_ID = 'VERSION_ID';
    const VERSION_NAME = 'VERSION_NAME';
    const MODEL_ID = 'MODEL_ID';
    const MODEL_NAME = 'MODEL_NAME';
    const MODEL_GROUP_NAME = 'MODEL_GROUP_NAME';
    const MODIFIED = 'MODIFIED';
    const PRODUCTION_YEAR = 'PRODUCTION_YEAR';
    const PRODUCTION_DATE = 'PRODUCTION_DATE';
    const FRY_DATE = 'FRY_DATE';
    const CCF_DATE = 'CCF_DATE';
    const OCF_DATE = 'OCF_DATE';
    const ORDER_DATE = 'ORDER_DATE';
    const BASE_PRICE = 'BASE_PRICE';
    const DISCOUNT_MANUFACTURER = 'DISCOUNT_MANUFACTURER';
    const DISCOUNT_DEALER = 'DISCOUNT_DEALER';
    const PRICE = 'PRICE';
    const LEASING_INSTALLMENT = 'LEASING_INSTALLMENT';
    const BUILDING_PRICE = 'BUILDING_PRICE';
    const STATUS = 'STATUS';
    const STATUS_NAME = 'STATUS_NAME';
    const PREVIOUS_STATUS = 'PREVIOUS_STATUS';
    const PREVIOUS_STATUS_NAME = 'PREVIOUS_STATUS_NAME';
    const IMAGES_COUNT = 'IMAGES_COUNT';
    const KM0 = 'KM0';
    const DEMO = 'DEMO';
    const EQUIPMENT_OPTIONAL = 'EQUIPMENT_OPTIONAL';
    const VIN = 'VIN';
    const TAGS = 'TAGS';
    const SQUARE = 'SQUARE';
    const MILEAGE = 'MILEAGE';
    const COLOR_CODE = 'COLOR_CODE';
    const COLOR_NAME = 'COLOR_NAME';
    const INTERIOR_CODE = 'INTERIOR_CODE';
    const INTERIOR_NAME = 'INTERIOR_NAME';

    /** @var string[]  */
    private $fields_names = [
        self::ID => 'ID',
        self::SERIAL_NO => 'Numer nadwozia',
        self::BRAND_ID => 'Kod marki',
        self::BRAND_NAME => 'Marka',
        self::DEALER_ADD => 'Dodana przez dealera',
        self::DEALER_SINCOM => 'Sincom dealera',
        self::DEALER_NAME => 'Nazwa dealera',
        self::VERSION_ID => 'Kod wersji',
        self::VERSION_NAME => 'Nazwa wersji',
        self::MODEL_ID => 'Kod modelu',
        self::MODEL_NAME => 'Nazwa modelu',
        self::MODEL_GROUP_NAME => 'Nazwa grupy modelu',
        self::MODIFIED => 'Ostatnia modyfikacja',
        self::PRODUCTION_YEAR => 'Rok produkcji',
        self::PRODUCTION_DATE => 'Data produkcji',
        self::FRY_DATE => 'Data faktury',
        self::CCF_DATE => 'Data CCF',
        self::OCF_DATE => 'Data OCF',
        self::ORDER_DATE => 'Data zamówienia',
        self::BASE_PRICE => 'Cena bazowa',
        self::DISCOUNT_MANUFACTURER => 'Rabat producenta',
        self::DISCOUNT_DEALER => 'Rabat dealera',
        self::PRICE => 'Cena po rabatach',
        self::LEASING_INSTALLMENT => 'Rata leasingu',
        self::BUILDING_PRICE => 'Cena zabudowy',
        self::STATUS => 'Kod statusu',
        self::STATUS_NAME => 'Status sprzedaży',
     //   self::PREVIOUS_STATUS => 'Poprzedni status',
        self::PREVIOUS_STATUS_NAME => 'Poprzedni status',
        self::IMAGES_COUNT => 'Ilość zdjęć',
        self::KM0 => 'KM0',
        self::DEMO => 'DEMO',
        self::EQUIPMENT_OPTIONAL => 'Wyposażenie opcjonalne',
        self::VIN => 'VIN',
        self::TAGS => 'Tagi',
        self::SQUARE => 'Plac',
        self::MILEAGE => 'Przebieg',
        self::COLOR_CODE => 'Kod koloru',
        self::COLOR_NAME => 'Nazwa koloru',
        self::INTERIOR_CODE => 'Kod wnętrza',
        self::INTERIOR_NAME => 'Nazwa wnętrza',
    ];

    /** @var string[] */
    private $selected_fields = [];

    /**
     * @return string[]
     */
    public function getFieldNames(): array
    {
        return $this->fields_names;
    }

    public function getFieldName($field): string
    {
        return $this->fields_names[$field] ?? '-- BRAK --';
    }

    /**
     * @return string[]
     */
    public function getFieldKeys(): array
    {
        return array_keys($this->fields_names);
    }

    /**
     * @param string[] $fields
     * @throws \FCA\StockExporter\Exception\IncorrectField|\Exception
     */
    public function setSelectedFields(array $fields): void
    {
        foreach ($fields as $field) {
            if (!in_array($field, $this->getFieldKeys())) {
                throw new IncorrectField("'{$field}' field is unsupported");
            }
            $this->selected_fields[] = $field;
        }
        if (empty($this->selected_fields)) {
            throw new \Exception('Too few selected fields');
        }
    }

    public function isSelectedField(string $field): bool
    {
        return in_array($field, $this->selected_fields);
    }

    /**
     * @return string[]
     */
    public function getSelectedFields(): array
    {
        return $this->selected_fields;
    }
}
