<?php

namespace FCA\StockExporter\ExportFile;

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Csv;

class CsvType extends BaseFile
{
    use SpreadsheetTrait;

    const TYPE_CSV = 'CSV';

    /** @var string */
    protected $file_ext = '.csv';

    /** @var Spreadsheet */
    private $spreadsheet;

    /** @var \PhpOffice\PhpSpreadsheet\Worksheet\Worksheet */
    private $sheet;

    /**
     * Create export file object, set top row and set widths of columns
     *
     * @throws \PhpOffice\PhpSpreadsheet\Exception
     */
    public function initFile(): void
    {
        $this->initSpreadsheet();

        $col_index = 1;
        foreach ($this->getExportField()->getFieldKeys() as $field) {
            if (in_array($field, $this->getExportField()->getSelectedFields())) {
                /** Set header names */
                $this->sheet->setCellValue(
                    $this->getCellAddress(1, $col_index),
                    $this->getExportField()->getFieldName($field)
                );
                $col_index++;
            }
        }
    }

    /**
     * @throws \Exception
     */
    public function closeFile(): void
    {
        $writer = new Csv($this->spreadsheet);
        $writer->setDelimiter(';');
        $writer->setLineEnding("\r\n");
        $writer->setSheetIndex(0);
        $this->closeSpreadsheetFile($writer);
    }
}
