<?php

namespace FCA\StockExporter\ExportFile;

use FCA\StockExporter\ExportField;
use FCA\StockExporter\ExportFilter;
use FCA\StockExporter\VehicleInterface;

interface TypeInterface
{
    public function initFile(): void;
    public function getZipped(): bool;
    public function setZipped(bool $zipped): void;
    public function addVehicleToFile(VehicleInterface $vehicle): void;
    public function closeFile(): void;
    public function getExportName(): string;
    public function getExportFilePath(): string;
    public function getFileExt(): string;
    public function getExportFilter(): ExportFilter;
    public function getExportField(): ExportField;
    public function setExportFilePath(string $export_file_path): void;
}
