<?php

namespace FCA\StockExporter\ExportFile;

use FCA\StockExporter\VehicleInterface;
use SimpleXMLElement;

class XmlType extends BaseFile
{
    const TYPE_XML = 'XML';

    /** @var string */
    protected $file_ext = '.xml';

    /** @var SimpleXMLElement */
    private $xml_object;

    public function initFile(): void
    {
        $this->xml_object = new SimpleXMLElement('<stock/>');
    }

    public function addVehicleToFile(VehicleInterface $vehicle): void
    {
        $xml_v = $this->xml_object->addChild('vehicle');
        $xml_v->addAttribute('id', $vehicle->getId());
        foreach ($this->getExportField()->getFieldKeys() as $field) {
            if (in_array($field, $this->getExportField()->getSelectedFields())) {
                $xml_v->addChild($field, htmlspecialchars($this->fieldDataFormatFormatter($vehicle, $field)));
            }
        }
    }

    /**
     * @throws \Exception
     */
    public function closeFile(): void
    {
        $file_path = $this->getTempDir() . DIRECTORY_SEPARATOR . $this->getExportName() . $this->getFileExt();
        $this->xml_object->saveXML($file_path);
        $this->setExportFilePath($file_path);
        $this->zippingIfRequired($file_path);
    }
}
