<?php

namespace FCA\StockExporter;

class ExportFilter
{
    /**
     * @var string[]
     */
    private $brands = [];

    public function addBrand(string $brand): void
    {
        if (!in_array($brand, $this->brands)) {
            $this->brands[] = $brand;
        }
    }

    /**
     * @param string[] $brands
     */
    public function setBrands(array $brands): void
    {
        $this->brands = array_unique(array_merge($this->brands, $brands));
    }

    public function checkVehicle(VehicleInterface $vehicle): bool
    {
        /**
         * First condition that checks if offer is valid for an export.
         * If offer is not in selected brands, it will not be added to export file.
         */
        if (!in_array($vehicle->getBrandId(), $this->brands)) {
            return false;
        }

        return true;
    }
}
