<?php

namespace FCA\StockExporter;

class Vehicle implements VehicleInterface
{
    private $property = [];

    public function getId(): ?int
    {
        return $this->getProperty(ExportField::ID);
    }

    public function setId(?int $id): void
    {
        $this->setProperty(ExportField::ID, $id);
    }

    public function getSerialId(): string
    {
        return $this->getProperty(ExportField::SERIAL_NO);
    }

    public function setSerialId(string $serial_id): void
    {
        $this->setProperty(ExportField::SERIAL_NO, $serial_id);
    }

    public function getBrandId(): ?string
    {
        return $this->getProperty(ExportField::BRAND_ID);
    }

    public function setBrandId(?string $brand): void
    {
        $this->setProperty(ExportField::BRAND_ID, $brand);
    }

    public function getBrandName(): ?string
    {
        return $this->getProperty(ExportField::BRAND_NAME);
    }

    public function setBrandName(?string $brand_string): void
    {
        $this->setProperty(ExportField::BRAND_NAME, $brand_string);
    }

    public function getVersionId(): ?string
    {
        return $this->getProperty(ExportField::VERSION_ID);
    }

    public function setVersionId(?string $version_id): void
    {
        $this->setProperty(ExportField::VERSION_ID, $version_id);
    }

    public function getVersionName(): ?string
    {
        return $this->getProperty(ExportField::VERSION_NAME);
    }

    public function setVersionName(?string $version_id): void
    {
        $this->setProperty(ExportField::VERSION_NAME, $version_id);
    }

    public function getModelId(): ?string
    {
        return $this->getProperty(ExportField::MODEL_ID);
    }

    public function setModelId(?string $model_id): void
    {
        $this->setProperty(ExportField::MODEL_ID, $model_id);
    }

    public function getModelName(): ?string
    {
        return $this->getProperty(ExportField::MODEL_NAME);
    }

    public function setModelName(?string $model_name): void
    {
        $this->setProperty(ExportField::MODEL_NAME, $model_name);
    }

    public function getModelGroupName(): ?string
    {
        return $this->getProperty(ExportField::MODEL_GROUP_NAME);
    }

    public function setModelGroupName(?string $model_group_name): void
    {
        $this->setProperty(ExportField::MODEL_GROUP_NAME, $model_group_name);
    }

    public function getProductionYear(): ?int
    {
        return $this->getProperty(ExportField::PRODUCTION_YEAR);
    }

    public function setProductionYear(?int $production_year): void
    {
        $this->setProperty(ExportField::PRODUCTION_YEAR, $production_year);
    }

    public function getProductionDate(): ?string
    {
        return $this->getProperty(ExportField::PRODUCTION_DATE);
    }

    public function setProductionDate(?string $production_date): void
    {
        $this->setProperty(ExportField::PRODUCTION_DATE, $production_date);
    }

    public function getBasePrice(): ?float
    {
        return $this->getProperty(ExportField::BASE_PRICE);
    }

    public function setBasePrice(?float $base_price): void
    {
        $this->setProperty(ExportField::BASE_PRICE, $base_price);
    }

    public function getDiscountManufacturer(): ?float
    {
        return $this->getProperty(ExportField::DISCOUNT_MANUFACTURER);
    }

    public function setDiscountManufacturer(?float $discount_manufacturer): void
    {
        $this->setProperty(ExportField::DISCOUNT_MANUFACTURER, $discount_manufacturer);
    }

    public function getDiscountDealer(): ?float
    {
        return $this->getProperty(ExportField::DISCOUNT_DEALER);
    }

    public function setDiscountDealer(?float $discount_dealer): void
    {
        $this->setProperty(ExportField::DISCOUNT_DEALER, $discount_dealer);
    }

    public function getPrice(): ?float
    {
        return $this->getProperty(ExportField::PRICE);
    }

    public function setPrice(?float $price): void
    {
        $this->setProperty(ExportField::PRICE, $price);
    }

    public function getLeasingInstallment(): ?float
    {
        return $this->getProperty(ExportField::LEASING_INSTALLMENT);
    }

    public function setLeasingInstallment(?float $leasing_installment): void
    {
        $this->setProperty(ExportField::LEASING_INSTALLMENT, $leasing_installment);
    }

    public function getBuildingPrice(): ?float
    {
        return $this->getProperty(ExportField::BUILDING_PRICE);
    }

    public function setBuildingPrice(?float $building_price): void
    {
        $this->setProperty(ExportField::BUILDING_PRICE, $building_price);
    }

    public function getStatus(): ?int
    {
        return $this->getProperty(ExportField::STATUS);
    }

    public function setStatus(?int $status): void
    {
        $this->setProperty(ExportField::STATUS, $status);
    }

    public function getStatusName(): ?string
    {
        return $this->getProperty(ExportField::STATUS_NAME);
    }

    public function setStatusName(?string $status_name): void
    {
        $this->setProperty(ExportField::STATUS_NAME, $status_name);
    }

    public function getPreviousStatus(): ?int
    {
        return $this->getProperty(ExportField::PREVIOUS_STATUS);
    }

    public function setPreviousStatus(?int $previous_status): void
    {
        $this->setProperty(ExportField::PREVIOUS_STATUS, $previous_status);
    }

    public function getPreviousStatusName(): ?string
    {
        return $this->getProperty(ExportField::PREVIOUS_STATUS_NAME);
    }

    public function setPreviousStatusName(?string $previous_status_name): void
    {
        $this->setProperty(ExportField::PREVIOUS_STATUS_NAME, $previous_status_name);
    }

    public function getImagesCount(): ?int
    {
        return $this->getProperty(ExportField::IMAGES_COUNT);
    }

    public function setImagesCount(?int $mages_count): void
    {
        $this->setProperty(ExportField::IMAGES_COUNT, $mages_count);
    }

    public function getDealerSincom(): ?string
    {
        return $this->getProperty(ExportField::DEALER_SINCOM);
    }

    public function setDealerSincom(?string $dealer_sincom): void
    {
        $this->setProperty(ExportField::DEALER_SINCOM, $dealer_sincom);
    }

    public function getDealerName(): ?string
    {
        return $this->getProperty(ExportField::DEALER_NAME);
    }

    public function setDealerName(?string $dealer_name): void
    {
        $this->setProperty(ExportField::DEALER_NAME, $dealer_name);
    }

    public function getDealerAdd(): ?bool
    {
        return $this->getProperty(ExportField::DEALER_ADD);
    }

    public function setDealerAdd(?bool $dealer_add): void
    {
        $this->setProperty(ExportField::DEALER_ADD, $dealer_add);
    }

    public function getKm0(): ?bool
    {
        return $this->getProperty(ExportField::KM0);
    }

    public function setKm0(?bool $km0): void
    {
        $this->setProperty(ExportField::KM0, $km0);
    }

    public function getDemo(): ?bool
    {
        return $this->getProperty(ExportField::DEMO);
    }

    public function setDemo(?bool $demo): void
    {
        $this->setProperty(ExportField::DEMO, $demo);
    }

    public function getFryDate(): ?string
    {
        return $this->getProperty(ExportField::FRY_DATE);
    }

    public function setFryDate(?string $fry_date): void
    {
        $this->setProperty(ExportField::FRY_DATE, $fry_date);
    }

    public function getCcfDate(): ?string
    {
        return $this->getProperty(ExportField::CCF_DATE);
    }

    public function setCcfDate(?string $ccf_date): void
    {
        $this->setProperty(ExportField::CCF_DATE, $ccf_date);
    }

    public function getOcfDate(): ?string
    {
        return $this->getProperty(ExportField::OCF_DATE);
    }

    public function setOcfDate(?string $ocf_date): void
    {
        $this->setProperty(ExportField::OCF_DATE, $ocf_date);
    }

    public function getOrderDate(): ?string
    {
        return $this->getProperty(ExportField::ORDER_DATE);
    }

    public function setOrderDate(?string $order_date): void
    {
        $this->setProperty(ExportField::ORDER_DATE, $order_date);
    }

    public function getEquipmentOptional(): ?array
    {
        return $this->getProperty(ExportField::EQUIPMENT_OPTIONAL);
    }

    public function setEquipmentOptional(?array $equipment_standard): void
    {
        $this->setProperty(ExportField::EQUIPMENT_OPTIONAL, $equipment_standard);
    }

    public function getVin(): ?string
    {
        return $this->getProperty(ExportField::VIN);
    }

    public function setVin(?string $vin): void
    {
        $this->setProperty(ExportField::VIN, $vin);
    }

    public function getTags(): ?string
    {
        return $this->getProperty(ExportField::TAGS);
    }

    public function setTags(?string $tags): void
    {
        $this->setProperty(ExportField::TAGS, $tags);
    }

    public function getSquare(): ?string
    {
        return $this->getProperty(ExportField::SQUARE);
    }

    public function setSquare(?string $square): void
    {
        $this->setProperty(ExportField::SQUARE, $square);
    }

    public function getMileage(): ?int
    {
        return $this->getProperty(ExportField::MILEAGE);
    }

    public function setMileage(?int $mileage): void
    {
        $this->setProperty(ExportField::MILEAGE, $mileage);
    }

    public function getColorCode(): ?string
    {
        return $this->getProperty(ExportField::COLOR_CODE);
    }

    public function setColorCode(?string $color_code): void
    {
        $this->setProperty(ExportField::COLOR_CODE, $color_code);
    }

    public function getInteriorCode(): ?string
    {
        return $this->getProperty(ExportField::INTERIOR_CODE);
    }

    public function setInteriorCode(?string $interior_code): void
    {
        $this->setProperty(ExportField::INTERIOR_CODE, $interior_code);
    }

    public function getColorName(): ?string
    {
        return $this->getProperty(ExportField::COLOR_NAME);
    }

    public function setColorName(?string $color_name): void
    {
        $this->setProperty(ExportField::COLOR_NAME, $color_name);
    }

    public function getInteriorName(): ?string
    {
        return $this->getProperty(ExportField::INTERIOR_NAME);
    }

    public function setInteriorName(?string $interior_name): void
    {
        $this->setProperty(ExportField::INTERIOR_NAME, $interior_name);
    }

    public function getModified(): ?int
    {
        return $this->getProperty(ExportField::MODIFIED);
    }

    public function setModified(?int $modified): void
    {
        $this->setProperty(ExportField::MODIFIED, $modified);
    }

    public function setProperty(string $key, $value): void
    {
        $this->property[$key] = $value;
    }

    public function getProperty(string $key, $default = null)
    {
        return $this->property[$key] ?? $default;
    }
}
