<?php

namespace FCA\StockExporter;

interface VehicleInterface
{
    public function setProperty(string $key, $value): void;
    public function getProperty(string $key, $default = null);

    public function getId(): ?int;
    public function setId(?int $id): void;

    public function getSerialId(): string;
    public function setSerialId(string $serial_id): void;

    public function getBrandId(): ?string;
    public function setBrandId(?string $brand): void;
    public function getBrandName(): ?string;
    public function setBrandName(?string $brand_string): void;

    public function getVersionId(): ?string;
    public function setVersionId(?string $version_id): void;
    public function getVersionName(): ?string;
    public function setVersionName(?string $version_id): void;

    public function getModelId(): ?string;
    public function setModelId(?string $model_id): void;
    public function getModelName(): ?string;
    public function setModelName(?string $model_name): void;
    public function getModelGroupName(): ?string;
    public function setModelGroupName(?string $model_group_name): void;

    public function getProductionYear(): ?int;
    public function setProductionYear(?int $production_year): void;
    public function getProductionDate(): ?string;
    public function setProductionDate(?string $production_date): void;

    public function getBasePrice(): ?float;
    public function setBasePrice(?float $base_price): void;
    public function getDiscountManufacturer(): ?float;
    public function setDiscountManufacturer(?float $discount_manufacturer): void;
    public function getDiscountDealer(): ?float;
    public function setDiscountDealer(?float $discount_dealer): void;
    public function getPrice(): ?float;
    public function setPrice(?float $price): void;
    public function getLeasingInstallment(): ?float;
    public function setLeasingInstallment(?float $leasing_installment): void;
    public function getBuildingPrice(): ?float;
    public function setBuildingPrice(?float $building_price): void;

    public function getStatus(): ?int;
    public function setStatus(?int $status): void;
    public function getStatusName(): ?string;
    public function setStatusName(?string $status_name): void;
    public function getPreviousStatus(): ?int;
    public function setPreviousStatus(?int $previous_status): void;
    public function getPreviousStatusName(): ?string;
    public function setPreviousStatusName(?string $previous_status_name): void;

    public function getModified(): ?int;
    public function setModified(?int $modified): void;

    public function getImagesCount(): ?int;
    public function setImagesCount(?int $mages_count): void;

    public function getDealerSincom(): ?string;
    public function setDealerSincom(?string $dealer_sincom): void;
    public function getDealerName(): ?string;
    public function setDealerName(?string $dealer_name): void;
    public function getDealerAdd(): ?bool;
    public function setDealerAdd(?bool $dealer_add): void;

    public function getKm0(): ?bool;
    public function setKm0(?bool $km0): void;
    public function getDemo(): ?bool;
    public function setDemo(?bool $demo): void;

    public function getFryDate(): ?string;
    public function setFryDate(?string $fry_date): void;
    public function getCcfDate(): ?string;
    public function setCcfDate(?string $ccf_date): void;
    public function getOcfDate(): ?string;
    public function setOcfDate(?string $ocf_date): void;
    public function getOrderDate(): ?string;
    public function setOrderDate(?string $order_date): void;

    public function getEquipmentOptional(): ?array;
    public function setEquipmentOptional(?array $equipment_standard): void;

    public function getVin(): ?string;
    public function setVin(?string $vin): void;
    public function getTags(): ?string;
    public function setTags(?string $tags): void;
    public function getSquare(): ?string;
    public function setSquare(?string $square): void;
    public function getMileage(): ?int;
    public function setMileage(?int $mileage): void;

    public function getColorCode(): ?string;
    public function setColorCode(?string $color_code): void;
    public function getInteriorCode(): ?string;
    public function setInteriorCode(?string $interior_code): void;
    public function getColorName(): ?string;
    public function setColorName(?string $color_name): void;
    public function getInteriorName(): ?string;
    public function setInteriorName(?string $interior_name): void;
}
