<?php

namespace FCAPoland\VehicleApiHelper;

/**
 * Class Brand
 * @package FCAPoland\ApiMasterkeyHelper
 */
class Brand
{
    /** @var string */
    private $id;
    /** @var string */
    private $name;
    /** @var string */
    private $slug;

    /**
     * Brand constructor.
     * @param $id
     * @param $name
     * @param $slug
     */
    public function __construct($id, $name, $slug)
    {
        $this->id = $id;
        $this->name = $name;
        $this->slug = $slug;
        return $this;
    }

    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getSlug()
    {
        return $this->slug;
    }

    /**
     * @return array
     */
    public function asArray()
    {
        return [
            'id' => $this->getId(),
            'name' => $this->getName(),
            'slug' => $this->getSlug()
        ];
    }
}
