<?php

namespace FCAPoland\VehicleApiHelper;

/**
 * Class Model
 * @package FCAPoland\ApiMasterkeyHelper
 */
class Model
{
    /** @var String */
    private $id;
    /** @var String */
    private $code;
    /** @var String */
    private $name;
    /** @var Brand */
    private $brand;

    /**
     * Model constructor.
     * @param $id
     * @param $code
     * @param $name
     * @param $brand_id
     * @param Brand $brand
     */
    public function __construct($id, $code, $name, Brand $brand)
    {
        $this->id = $id;
        $this->code = $code;
        $this->name = $name;
        $this->brand = $brand;
        return $this;
    }

    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @return Brand
     */
    public function getBrand()
    {
        return $this->brand;
    }

    /**
     * @return array
     */
    public function asArray()
    {
        return [
            'id' => $this->getId(),
            'code' => $this->getCode(),
            'name' => $this->getName(),
            'brand' => $this->getBrand()->asArray()
        ];
    }
}
