<?php

namespace FCAPoland\VehicleApiHelper;

use FCAPoland\VehicleApiHelper\Brand\Collection as BrandsCollection;
use FCAPoland\VehicleApiHelper\Model\Collection as ModelsCollection;
use Psr\SimpleCache\CacheInterface;

/**
 * Class VehicleHelper
 * @package FCAPoland\VehicleApiHelper
 */
class VehicleHelper
{
    const CACHE_KEY = 'vehicle-api-helper:';

    /**
     * @var CacheInterface
     */
    private $cache;

    private $brands;

    private $models;

    /**
     * VehicleHelper constructor.
     */
    public function __construct()
    {
        $this->brands = new BrandsCollection();
        $this->models = new ModelsCollection();
        return $this;
    }

    /**
     * @param CacheInterface $cache
     */
    public function setCache(CacheInterface $cache)
    {
        $this->cache = $cache;
        $this->brands->setCache($this->cache);
        $this->models->setCache($this->cache);
        return $this;
    }

    /**
     * @throws Exception
     * @throws \Psr\SimpleCache\InvalidArgumentException
     */
    public function init()
    {
        $this->brands->fetchBrands();
        $this->models->fetchModels();
        return $this;
    }

    /**
     * @return BrandsCollection
     */
    public function getBrands()
    {
        return $this->brands;
    }

    /**
     * @return ModelsCollection
     */
    public function getModels()
    {
        return $this->models;
    }
}
