Vehicle API Helper
=================

Library helpful when working with vehicle-related resources of FCA API.

Simple usage by example:

1. Include the library in your project:

   `$ composer require fca-poland/vehicle-api-helper`

2. Use it:

Basic usage:    
    
    <?php
    require_once "vendor/autoload.php"; 
    $vehicle_helper = new VehicleHelper();

    $vehicle_helper->setCache(CacheInterface $cache);
    
    $vehicle_helper->init();

    $brands = $vehicle_helper->getBrands();
    $models = $vehicle_helper->getModels();
    
    
 
Development
-----------

> For Docker development environment see next section.

1. Instal development dependencies:

    `$ composer install --dev`

2. Checkout to development branch:

    `$ git checkout -b dev/feature-1`

3. Do the development (remember about tests!)
4. Make your code better - for lazy programmers:

    ```
    $ ./sniff-the-code-fixer.sh
    ```  
 
5. Sniff the code and detect mess:

    ```
    $ ./sniff-the-code.sh
    $ ./detect-mess.sh
    ``` 
    
    
7. Merge or create merge request.
8. Be happy PHP developer!