<?php

namespace FCAPoland\VehicleApiHelper;

use FCAPoland\VehicleApiHelper\Brand\Collection as BrandsCollection;
use FCAPoland\VehicleApiHelper\Model\Collection as ModelsCollection;
use Psr\SimpleCache\CacheInterface;
use Psr\SimpleCache\InvalidArgumentException;

/**
 * Class VehicleHelper
 * @package FCAPoland\VehicleApiHelper
 */
class VehicleHelper
{
    const CACHE_KEY = 'vehicle-api-helper:';

    /** @var CacheInterface|null */
    private $cache;

    /** @var BrandsCollection  */
    private $brands;

    /** @var ModelsCollection  */
    private $models;

    /**
     * VehicleHelper constructor.
     */
    public function __construct()
    {
        $this->brands = new BrandsCollection();
        $this->models = new ModelsCollection();
        return $this;
    }

    /**
     * @param CacheInterface $cache
     * @return VehicleHelper
     */
    public function setCache(CacheInterface $cache)
    {
        $this->cache = $cache;
        $this->brands->setCache($this->cache);
        $this->models->setCache($this->cache);
        return $this;
    }

    /**
     * @throws Exception
     * @throws InvalidArgumentException
     */
    public function init()
    {
        $this->brands->fetchBrands();
        $this->models->fetchModels();
        return $this;
    }

    /**
     * @return BrandsCollection
     */
    public function getBrands()
    {
        return $this->brands;
    }

    /**
     * @return ModelsCollection
     */
    public function getModels()
    {
        return $this->models;
    }
}
