<?php

declare(strict_types=1);

namespace Stellantis\ExPsaApiHelper;

use GuzzleHttp\Client;
use Psr\SimpleCache\CacheInterface;

abstract class Base
{
    private const CACHE_PREFIX = 'expsa_api_helper_';
    protected Client $client;
    private ?CacheInterface $cache = null;

    public function __construct(
        string $base_uri,
        ?string $username = null,
        ?string $password = null,
        ?callable $handler = null
    ) {
        $this->client = new Client([
            'base_uri' => rtrim($base_uri, '/') . '/',
            'auth' => [$username, $password],
            'verify' => false,
            'handler' => $handler
        ]);
    }

    public function setCache(CacheInterface $cache): self
    {
        $this->cache = $cache;

        return $this;
    }

    protected function loadFromCache(string $key)
    {
        if ($this->cache instanceof CacheInterface) {
            return $this->cache->get(self::CACHE_PREFIX . $key);
        }
        return null;
    }

    protected function saveToCache(string $key, $value): bool
    {
        if ($this->cache instanceof CacheInterface) {
            return $this->cache->set(self::CACHE_PREFIX . $key, $value);
        }
        return false;
    }
}
