<?php

declare(strict_types=1);

namespace Stellantis\ExPsaApiHelper\Model;

use Stellantis\ExPsaApiHelper\Exception\ExPSAAPIException;

class Region
{
    /**
     * value → label
     */
    private const MAP = [
        'woj1' => 'dolnośląskie',
        'woj2' => 'kujawsko-pomorskie',
        'woj3' => 'lubelskie',
        'woj4' => 'lubuskie',
        'woj5' => 'łódzkie',
        'woj6' => 'małopolskie',
        'woj7' => 'mazowieckie',
        'woj8' => 'opolskie',
        'woj9' => 'podkarpackie',
        'woj10' => 'podlaskie',
        'woj11' => 'pomorskie',
        'woj12' => 'śląskie',
        'woj13' => 'świętokrzyskie',
        'woj14' => 'warmińsko-mazurskie',
        'woj15' => 'wielkopolskie',
        'woj16' => 'zachodniopomorskie',
    ];

    private ?string $value = null;
    private ?string $label = null;

    public function getValue(): ?string
    {
        return $this->value;
    }

    public function setValue(?string $value): self
    {
        if (!array_key_exists($value, self::MAP)) {
            throw new ExPSAAPIException('Invalid region value: ' . $value);
        }
        $this->value = $value;
        $this->label = self::MAP[$value];

        return $this;
    }

    public function getLabel(): ?string
    {
        return $this->label;
    }

    public function setLabel(?string $label): self
    {
        if (!in_array($label, self::MAP)) {
            throw new ExPSAAPIException('Invalid region label: ' . $label);
        }
        $this->label = $label;
        $this->value = array_flip(self::MAP)[$label];

        return $this;
    }
}
