<?php

declare(strict_types=1);

namespace Stellantis\ExPsaApiHelper\Model;

use Stellantis\ExPsaApiHelper\Exception\ExPSAAPIException;

class Model
{
    private ?Brand $brand = null;
    private ?string $name = null;
    private ?string $type = null;
    private ?string $lcdv6 = null;
    private ?int $model_year = null;
    private ?string $vehicle_note = null;

    public function getBrand(): ?Brand
    {
        return $this->brand;
    }

    public function setBrand(?Brand $brand): Model
    {
        $this->brand = $brand;

        return $this;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): Model
    {
        $this->name = $name;

        return $this;
    }

    public function getType(): ?string
    {
        return $this->type;
    }

    public function setType(?string $type): Model
    {
        if (!is_null($type) and !Type::isValid($type)) {
            throw new ExPSAAPIException(
                'Invalid type: ' . $type . '. Valid values are: ' . join(', ', Type::getAll())
            );
        }
        $this->type = $type;

        return $this;
    }

    public function getLcdv6(): ?string
    {
        return $this->lcdv6;
    }

    public function setLcdv6(?string $lcdv6): Model
    {
        $this->lcdv6 = $lcdv6;

        return $this;
    }

    public function getModelYear(): ?int
    {
        return $this->model_year;
    }

    public function setModelYear(?int $model_year): Model
    {
        $this->model_year = $model_year;

        return $this;
    }

    public function getVehicleNote(): ?string
    {
        return $this->vehicle_note;
    }

    public function setVehicleNote(?string $vehicle_note): Model
    {
        $this->vehicle_note = $vehicle_note;

        return $this;
    }
}
