<?php

declare(strict_types=1);

namespace Stellantis\ExPsaApiHelper\Filter;

use Stellantis\ExPsaApiHelper\Exception\ExPSAAPIException;
use Webmozart\Assert\Assert;
use Webmozart\Assert\InvalidArgumentException;

class Dealer
{
    use Traits\BrandsTrait;

    private ?bool $active = null;
    private array $rrdi = [];
    private array $rrdi7 = [];
    private array $parent_rrdi = [];
    private array $bac = [];
    private array $regions = [];

    public function getActive(): ?bool
    {
        return $this->active;
    }

    public function setActive(?bool $active): self
    {
        $this->active = $active;

        return $this;
    }

    public function clearActive(): self
    {
        $this->active = null;

        return $this;
    }

    public function getRRDI(): array
    {
        return $this->rrdi;
    }

    public function setRRDI(...$rrdi): self
    {
        try {
            Assert::allString($rrdi);
        } catch (InvalidArgumentException $exception) {
            throw new ExPSAAPIException(
                'Invalid type for RRDI code. Only strings are allowed',
                0,
                $exception
            );
        }
        $this->rrdi = $rrdi;

        return $this;
    }

    public function addRRDI(...$rrdi): self
    {
        $this->setRRDI(...array_merge($this->getRRDI(), $rrdi));

        return $this;
    }

    public function clearRRDI(): self
    {
        $this->rrdi = [];

        return $this;
    }

    public function getRRDI7(): array
    {
        return $this->rrdi7;
    }

    public function setRRDI7(...$rrdi7): self
    {
        try {
            Assert::allString($rrdi7);
        } catch (InvalidArgumentException $exception) {
            throw new ExPSAAPIException(
                'Invalid type for RRDI7 code. Only strings are allowed',
                0,
                $exception
            );
        }
        $this->rrdi7 = $rrdi7;

        return $this;
    }

    public function addRRDI7(...$rrdi7): self
    {
        $this->setRRDI7(...array_merge($this->getRRDI7(), $rrdi7));

        return $this;
    }

    public function clearRRDI7(): self
    {
        $this->rrdi7 = [];

        return $this;
    }

    public function getParentRRDI(): array
    {
        return $this->parent_rrdi;
    }

    public function setParentRRDI(...$rrdi): self
    {
        try {
            Assert::allString($rrdi);
        } catch (InvalidArgumentException $exception) {
            throw new ExPSAAPIException(
                'Invalid type for parent RRDI code. Only strings are allowed',
                0,
                $exception
            );
        }
        $this->parent_rrdi = $rrdi;

        return $this;
    }

    public function addParentRRDI(...$rrdi): self
    {
        $this->setParentRRDI(...array_merge($this->getParentRRDI(), $rrdi));

        return $this;
    }

    public function clearParentRRDI(): self
    {
        $this->parent_rrdi = [];

        return $this;
    }

    public function getBAC(): array
    {
        return $this->bac;
    }

    public function setBAC(...$bac): self
    {
        try {
            Assert::allString($bac);
        } catch (InvalidArgumentException $exception) {
            throw new ExPSAAPIException(
                'Invalid type for BAC code. Only numeric strings are allowed',
                0,
                $exception
            );
        }
        $this->bac = $bac;

        return $this;
    }

    public function addBAC(...$bac): self
    {
        $this->setBAC(...array_merge($this->getBAC(), $bac));

        return $this;
    }

    public function clearBAC(): self
    {
        $this->bac = [];

        return $this;
    }

    public function getRegions(): array
    {
        return $this->regions;
    }

    public function setRegions(...$regions): self
    {
        $this->regions = $regions;

        return $this;
    }

    public function addRegions(...$regions): self
    {
        $this->setRegions(...array_merge($this->getRegions(), $regions));

        return $this;
    }

    public function clearRegions(): self
    {
        $this->regions = [];

        return $this;
    }
}
