<?php

declare(strict_types=1);

namespace Stellantis\ExPsaApiHelper\Model;

use Stellantis\ExPsaApiHelper\Exception\ExPSAAPIException;

class Dealer
{
    private ?string $name = null;
    private ?bool $is_active = null;
    private ?Brand $brand = null;
    private ?string $rrdi = null;
    private ?string $rrdi7 = null;
    private ?string $parent_rrdi = null;
    private ?string $bac = null;
    private ?Region $region = null;
    private ?Address $address = null;
    private ?string $phone_no = null;
    private ?string $email = null;
    private ?Coordinate $coordinate = null;

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function isActive(): ?bool
    {
        return $this->is_active;
    }

    public function setActive(?bool $flag): self
    {
        $this->is_active = $flag;

        return $this;
    }

    public function getBrand(): ?Brand
    {
        return $this->brand;
    }

    public function setBrand(?Brand $brand): self
    {
        $this->brand = $brand;

        return $this;
    }

    public function getRRDI(): ?string
    {
        return $this->rrdi;
    }

    public function setRRDI(?string $rrdi): self
    {
        $this->rrdi = $rrdi;

        return $this;
    }

    public function getRRDI7(): ?string
    {
        return $this->rrdi7;
    }

    public function setRRDI7(?string $rrdi7): self
    {
        $this->rrdi7 = $rrdi7;

        return $this;
    }

    public function getParentRRDI(): ?string
    {
        return $this->parent_rrdi;
    }

    public function setParentRRDI(?string $parent_rrdi): self
    {
        $this->parent_rrdi = $parent_rrdi;

        return $this;
    }

    public function getBAC(): ?string
    {
        return $this->bac;
    }

    public function setBAC(?string $bac): self
    {
        $this->bac = $bac;

        return $this;
    }

    public function getRegion(): ?Region
    {
        return $this->region;
    }

    public function setRegion(?Region $region): self
    {
        $this->region = $region;

        return $this;
    }

    public function getAddress(): ?Address
    {
        return $this->address;
    }

    public function setAddress(?Address $address): self
    {
        $this->address = $address;

        return $this;
    }

    public function getPhoneNo(): ?string
    {
        return $this->phone_no;
    }

    public function setPhoneNo(?string $phone_no): self
    {
        $this->phone_no = $phone_no;

        return $this;
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setEmail(?string $email): self
    {
        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            throw new ExPSAAPIException('Invalid e-mail address: ' . $email);
        }
        $this->email = $email;

        return $this;
    }

    public function getCoordinate(): ?Coordinate
    {
        return $this->coordinate;
    }

    public function setCoordinate(?Coordinate $coordinate): self
    {
        $this->coordinate = $coordinate;

        return $this;
    }
}
