ExPSA API Helper
================

Library to aid working with (ex)PSA API (dealers, models, etc).

Examples of usage
-----------------

### Fetch only active Citroën dealers

```php
$dealers = new \Stellantis\ExPsaApiHelper\Dealers($base_uri, $username, $password);

$result = $dealers->get(
    (new \Stellantis\ExPsaApiHelper\Filter\Dealer())
        ->setBrands(\Stellantis\ExPsaApiHelper\Model\Brand::NAME_CITROEN)
);

while ($result->valid()) {
    /** @var \Stellantis\ExPsaApiHelper\Model\Dealer $dealer */
    $dealer = $result->current();
    // ... do something with the dealer
    echo $dealer->getName();
    $result->next();
}
```

### Fetch only Opel models for transport purposes (use cache)

```php
$models = new \Stellantis\ExPsaApiHelper\Models($base_uri, $username, $password);

/** @var \Psr\SimpleCache\CacheInterface $cache */
$models->setCache($cache);

$result = $models->get(
    (new \Stellantis\ExPsaApiHelper\Filter\Model())
        ->setBrands(\Stellantis\ExPsaApiHelper\Model\Brand::CODE_OPEL)
        ->setTypes(\Stellantis\ExPsaApiHelper\Model\Model\Type::TYPE_VU)
);

while ($result->valid()) {
    /** @var \Stellantis\ExPsaApiHelper\Model\Model $model */
    $model = $result->current();
    // ... do something with the model
    echo $model->getName() . ': ' . $model->getLcdv6();
    $result->next();
}
```
