<?php

namespace Stellantis\ExPsaApiHelper\Model\Dealer;

use Stellantis\ExPsaApiHelper\Exception\ExPSAAPIException;

class Email
{
    private string $signature;
    private string $address;

    public function __construct(string $signature, string $address)
    {
        if (!filter_var($address, FILTER_VALIDATE_EMAIL)) {
            throw new ExPSAAPIException(sprintf('Invalid e-mail address: %s', $address));
        }
        $this->signature = $signature;
        $this->address = $address;
    }

    public function getSignature(): string
    {
        return $this->signature;
    }

    public function getAddress(): string
    {
        return $this->address;
    }
}
