#!/usr/bin/env bash

echo "┌────────────────────────────────────────────────────────────────────────────┐"
echo "│ This helper script supports PHP version changing with:                     │"
echo "│                                                                            │"
echo "│     -pv [PHP_VER]                                                          │"
echo "│     --php-version [PHP_VER]                                                │"
echo "│                                                                            │"
echo "│ where [PHP_VER] is a numeric representation of PHP, such as 7.4 or 8.2     │"
echo "├────────────────────────────────────────────────────────────────────────────┤"

PHP_VERSION="default" # 7.4

if [ -n "$1" ]; then
    case "$1" in
        -pv|--php-version)
            PHP_VERSION="$2";
            shift 2
            ;;
        -pv=*|--php-version=*)
            PHP_VERSION="${1#*=}";
            shift 1
            ;;
      esac
fi

printf "│ Currently selected PHP version is: %-7s                                 │" $PHP_VERSION
echo ""
echo "└────────────────────────────────────────────────────────────────────────────┘"
