<?php

namespace Stellantis\ExPsaApiHelper;

class HttpClientOptions
{
    /**
     * Float describing the total timeout of the request in seconds. Use 0 to wait indefinitely (the default behavior)
     */
    private float $timeout = 0.0;

    /**
     * Float describing the total timeout of the request in seconds. 0 (default value) means: wait to the end of time
     */
    public function getTimeout(): float
    {
        return $this->timeout;
    }

    /**
     * Timeout in seconds. Use "0" (zero) to technically disable timeout and wait forever
     */
    public function withTimeout(float $timeout): self
    {
        $clone = clone $this;

        $clone->timeout = $timeout;

        return $clone;
    }
}
