<?php

declare(strict_types=1);

namespace Stellantis\ExPsaApiHelper\Model;

use Stellantis\ExPsaApiHelper\Model\Address\Region;

class Address
{
    private ?string $city = null;
    private ?string $street = null;
    private ?Region $region = null;

    private ?string $zipcode = null;

    public function getCity(): ?string
    {
        return $this->city;
    }

    public function setCity(?string $city): self
    {
        $this->city = $city;

        return $this;
    }

    public function getStreet(): ?string
    {
        return $this->street;
    }

    public function setStreet(?string $street): self
    {
        $this->street = $street;

        return $this;
    }

    public function getRegion(): ?Region
    {
        return $this->region;
    }

    public function setRegion(?Region $region): self
    {
        $this->region = $region;

        return $this;
    }

    public function getZipCode(): ?string
    {
        return $this->zipcode;
    }

    public function setZipCode(?string $zipcode): Address
    {
        if (!preg_match('/^\d{2}\W?\d{3}$/', $zipcode)) {
            $this->zipcode = 'Invalid ZIP code (' . $zipcode . ')';
        } else {
            $this->zipcode = preg_replace('/^(\d{2})\W?(\d{3})$/', '$1-$2', $zipcode);
        }

        return $this;
    }
}
