<?php

namespace Stellantis\ExPsaApiHelper\Model\Dealer;

class Email
{
    public const SIGNATURE_DEFAULT = 'Email';
    public const SIGNATURE_APV = 'EmailAPV';
    public const SIGNATURE_AGENT = 'EmailAgent';
    public const SIGNATURE_GER = 'EmailGER';
    public const SIGNATURE_GRC = 'EmailGRC';
    public const SIGNATURE_PR = 'EmailPR';
    public const SIGNATURE_SALES = 'EmailSales';
    public const SIGNATURE_VO = 'EmailVO';

    private string $signature;
    private string $address;

    public function __construct(string $signature, string $address)
    {
        if (filter_var($address, FILTER_VALIDATE_EMAIL)) {
            $this->address = $address;
        } else {
            $this->address = 'Invalid e-mail address (' . $address . ')';
        }
        if (self::isSignatureValid($signature)) {
            $this->signature = $signature;
        } else {
            $this->signature = 'Invalid e-mail signature (' . $signature . ')';
        }
    }

    public function getSignature(): string
    {
        return $this->signature;
    }

    public function getAddress(): string
    {
        return $this->address;
    }

    public static function isSignatureValid(string $signature): bool
    {
        return in_array(
            $signature,
            self::getValidSignatures()
        );
    }

    public static function getValidSignatures(): array
    {
        return [
            self::SIGNATURE_DEFAULT,
            self::SIGNATURE_APV,
            self::SIGNATURE_AGENT,
            self::SIGNATURE_GER,
            self::SIGNATURE_GRC,
            self::SIGNATURE_PR,
            self::SIGNATURE_SALES,
            self::SIGNATURE_VO,
        ];
    }
}
