<?php

namespace Stellantis\ExPsaApiHelper\Model\Dealer;

class Emails
{
    private array $list = [];

    public function add(Email ...$emails)
    {
        foreach ($emails as $email) {
            if (!isset($this->list[$email->getSignature()])) {
                $this->list[$email->getSignature()] = $email;
            }
        }
    }

    public function getAll(): array
    {
        return $this->list;
    }

    public function onlyWithSignatures(string ...$signatures): self
    {
        array_walk($signatures, function (string $signature) {
            if (!Email::isSignatureValid($signature)) {
                throw new \DomainException(sprintf(
                    'Invalid e-mail signature: %s. Valid signatures are: %s',
                    $signature,
                    implode(', ', Email::getValidSignatures())
                ));
            }
        });

        $clone = clone $this;

        $clone->list = array_filter(
            $this->list,
            fn(Email $email) => in_array($email->getSignature(), $signatures)
        );

        return $clone;
    }

    public function onlySales(): self
    {
        return $this->onlyWithSignatures(Email::SIGNATURE_SALES, Email::SIGNATURE_DEFAULT);
    }
}
