<?php

declare(strict_types=1);

use GuzzleHttp\Handler\MockHandler;
use GuzzleHttp\HandlerStack;
use GuzzleHttp\Psr7\Response;
use Stellantis\ExPsaApiHelper\Dealers;
use PHPUnit\Framework\TestCase;
use Stellantis\ExPsaApiHelper\Model\Brand;
use Stellantis\ExPsaApiHelper\Model\Dealer;
use Stellantis\ExPsaApiHelper\Model\Address\Region;
use Stellantis\ExPsaApiHelper\Filter\Dealer as DealerFilter;

class RegionsTest extends TestCase
{
    public function testRegionNameConversion()
    {
        $region_names = [
            'dolnoslaskie' => 'dolnośląskie',
            'dolnośląskie' => 'dolnośląskie',
            'Dolnośląskie' => 'dolnośląskie',
            'kujawsko-pomorskie' => 'kujawsko-pomorskie',
            'ŁÓDZKIE' => 'łódzkie',
            'Lubuskie' => 'lubuskie',
            'lubuskie' => 'lubuskie',
            'lubelskie' => 'lubelskie',
            'małopolskie' => 'małopolskie',
            'MAŁOPOLSKIE' => 'małopolskie',
            'mazowieckie' => 'mazowieckie',
            'Mazowieckie' => 'mazowieckie',
            'opolskie' => 'opolskie',
            'podkarpackie' => 'podkarpackie',
            'podlaskie' => 'podlaskie',
            'Poland' => 'łódzkie', // Jaszpol, ul. Szparagowa 4, Łódź
            'pomorskie' => 'pomorskie',
            'slaskie' => 'śląskie',
            'śląskie' => 'śląskie',
            'Śląskie' => 'śląskie',
            'warmińsko-mazurskie' => 'warmińsko-mazurskie',
            'Wielkopolska' => 'wielkopolskie',
            'wielkopolskie' => 'wielkopolskie',
            'zachodniopomorskie' => 'zachodniopomorskie',
        ];

        foreach ($region_names as $region_name => $correct_region_name) {
            $region = new Region();
            $region->setName($region_name);
            $this->assertEquals($correct_region_name, $region->getName());
        }
    }
}
