<?php

declare(strict_types=1);

namespace Stellantis\ExPsaApiHelper\Model;

use Stellantis\ExPsaApiHelper\Exception\ExPSAAPIException;

class Brand
{
    public const NAME_CITROEN = 'Citroën';
    public const CODE_CITROEN = 'AC';
    public const NAME_DS = 'DS';
    public const CODE_DS = 'DS';
    public const NAME_OPEL = 'Opel';
    public const CODE_OPEL = 'OV';
    public const NAME_PEUGEOT = 'Peugeot';
    public const CODE_PEUGEOT = 'AP';

    public const NAMES = [
        self::CODE_CITROEN => self::NAME_CITROEN,
        self::CODE_DS => self::NAME_DS,
        self::CODE_OPEL => self::NAME_OPEL,
        self::CODE_PEUGEOT => self::NAME_PEUGEOT,
    ];

    private ?string $name = null;
    private ?string $code = null;

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        if (!self::isNameValid($name)) {
            throw new ExPSAAPIException(sprintf('Invalid brand name: %s', $name));
        }
        $this->name = $name;
        foreach (self::NAMES as $brand_code => $brand_name) {
            if ($name === $brand_name) {
                $this->code = $brand_code;

                return $this;
            }
        }
        // This should never happen...
        throw new ExPSAAPIException(sprintf('Could not find code for brand %s', $name));
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(?string $code): self
    {
        if (!self::isCodeValid($code)) {
            throw new ExPSAAPIException(sprintf('Invalid brand code: %s', $code));
        }
        $this->code = $code;
        $this->name = self::NAMES[$this->code];

        return $this;
    }

    public static function isNameValid(string $name): bool
    {
        return in_array($name, self::NAMES);
    }

    public static function isCodeValid(string $name): bool
    {
        return array_key_exists($name, self::NAMES);
    }
}
