<?php

declare(strict_types=1);

namespace Stellantis\ExPsaApiHelper\Model;

class Brand
{
    public const NAME_CITROEN = 'Citroën';
    public const CODE_CITROEN = 'AC';
    public const NAME_DS = 'DS';
    public const CODE_DS = 'DS';
    public const NAME_OPEL = 'Opel';
    public const CODE_OPEL = 'OV';
    public const NAME_PEUGEOT = 'Peugeot';
    public const CODE_PEUGEOT = 'AP';

    public const NAMES = [
        self::CODE_CITROEN => self::NAME_CITROEN,
        self::CODE_DS => self::NAME_DS,
        self::CODE_OPEL => self::NAME_OPEL,
        self::CODE_PEUGEOT => self::NAME_PEUGEOT,
    ];

    private ?string $name = null;
    private ?string $code = null;

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        if (!self::isNameValid($name)) {
            $this->name = 'Invalid name (' . $name . ')';
            $this->code = 'N/A due to invalid name (' . $name . ')';

            return $this;
        }

        $this->name = $name;
        foreach (self::NAMES as $brand_code => $brand_name) {
            if ($name === $brand_name) {
                $this->code = $brand_code;
                break;
            }
        }

        return $this;
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(?string $code): self
    {
        if (self::isCodeValid($code)) {
            $this->code = $code;
            $this->name = self::NAMES[$this->code];
        } else {
            $this->code = 'Invalid code (' . $code . ')';
            $this->name = 'Invalid name due to invalid code (' . $code . ')';
        }

        return $this;
    }

    public static function isNameValid(string $name): bool
    {
        return in_array($name, self::NAMES);
    }

    public static function isCodeValid(string $name): bool
    {
        return array_key_exists($name, self::NAMES);
    }
}
