<?php

echo <<<STDOUT

WARNING!
========
This script will fetch "fresh" exPSA dealer data and save it as `dealer.[brand].json` files overwriting current
ones. It will also create a new `dealers.all.json` file that is a composition (merge) of distinct brand files,
preserving structure and being valid JSON file.

New JSON files may cause tests to fail.

Press [ENTER] to continue or [CTRL+C] to quit.

STDOUT;

fgets(STDIN);

$brands = [
    'citroen' => 'AC',
    'ds' => 'DS',
    'opel' => 'OV',
    'peugeot' => 'AP',
];

$query_defaults = [
    'Country' => 'pl',
    'Culture' => 'pl',
    'IndicatorsActivities' => '',
    'Latitude' => '',
    'Longitude' => '',
    'RMax' => '',
    'Consumer' => 'Autobiz',
    'Details' => 'max',
    'Brand' => '',
    'Sort' => 'distance',
    'ResultMax' => '',
    'Criterias' => '',
    'Unit' => 'km',
    'CriteriasExclude' => '0',
    'GmCodeList' => 'VN',
];

$base_url = 'https://annuaire-pdv.servicesgp.mpsa.com/Services/DealerService.svc/rest/GetDealerList?parameters=';

$all_brands = [];
$first = true;

foreach ($brands as $brand_slug => $brand_code) {
    $full_url = $base_url . urlencode(
        json_encode(
            array_replace(
                $query_defaults,
                [
                    'Brand' => $brand_code,
                ]
            )
        )
    );

    $brand_dealers = file_get_contents($full_url);
    $brand_data = json_decode($brand_dealers, true, 512, JSON_THROW_ON_ERROR);
    if ($first) {
        $all_brands = $brand_data;
        $first = false;
    } else {
        $all_brands['Count'] += $brand_data['Count'];
        $all_brands['DealersFull'] = array_merge($all_brands['DealersFull'], $brand_data['DealersFull']);
    }
    unset($brand_data);

    file_put_contents(
        sprintf('dealers.%s.json', $brand_slug),
        $brand_dealers
    );
    unset($brand_dealers);
}

file_put_contents('dealers.all.json', json_encode($all_brands, JSON_THROW_ON_ERROR));

